<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Inventário</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.6.2">

  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.6.2">
  <!-- Toastr -->
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.6.2">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.6.2" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.6.2">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.261.6.2">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.261.6.2">


</head>
<style>
  .content-wrapper {
    margin-left: 0px !important;
  }

  .main-header,
  .main-sidebar {
    display: none;
  }

  #msform {
    text-align: start;
    position: relative;
  }

  .card {
    box-shadow: none !important;
    border-radius: 0 !important;
    margin-bottom: 0 !important;
  }

  .card-header {
    box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
  }

  .card-body {
    margin-left: 0px !important;
    padding-left: 1.25rem !important;
    padding-top: 0px;
    padding-bottom: 0px;
    padding-right: 1.25rem !important;
  }

  .header-content-page .title-page,
  .title-content-page .title,
  .title-page {
    font-size: 20px;
    line-height: normal;
    font-weight: 500;
    color: #343a40;
    margin: 0;
    font-family: Roboto, Arial, sans-serif;
  }

  .form-group {
    margin-bottom: 0.2rem;
  }

  .border-Field {
    border: 1px groove #ddd !important;
    padding: 0 1.4em 1.4em 1.4em !important;
    margin: 0 0 1.5em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
  }

  .border-Field .textoBorda {
    font-size: 1.2em !important;
    text-align: left !important;
    width: auto;
    padding: 0 10px;
    border-bottom: none;
  }

  .marginTop {
    margin-top: 8px;
  }

  @media (max-width: 768px) {
    #divImportar {
      margin-top: 0 !important;
    }
  }

  #divImportar {
    margin-top: 48px;
  }
</style>


<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <?php
    include_once('../../../menu.php');
    ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h3 class="col-mb=2"></h3>
            </div>
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">

                <li class="breadcrumb-item active">Gerar Inventário</li>
              </ol> -->
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card" style="height:auto;">
                <div class="card-header bg-dark">
                  <div class="row flex">
                    <h4 class="text-white">Gerar Inventário </h4>
                    <button title="Tutorial" class="btn btn-info btn-sm ml-2" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </div>
                </div>
                <fieldset>
                  <div class="card-body" style="padding-left: 0rem!important; padding-right: 0rem!important;">
                    <form id="msform" name="msform">
                      <div class="card card-body" style="padding-top: 10px;">
                        <div class="row" style="min-height: 150px;">
                          <div class="col-md-9 col-12">
                            <div class="col-12">
                              <div class="form-group col-xl-2 col-lg-3 col-sm-5 col-6">
                                <label data-error="wrong" data-success="right" for="txtLancamento">Lançamento:</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control validate" required id="txtLancamento" name="txtLancamento" placeholder="Lançamento">
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-md-6 col-12 form-group" id="DepositoInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtDeposito">Depósito *</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Deposito">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Deposito" name="btn-Deposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="form-group col-md-6 col-12">
                                  <label for="txtData">Data *</label>
                                  <div class="relative">
                                    <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtData">
                                  </div>
                                </div>
                              </div>
                              <div class="row marginTop">
                                <div class="col-md-6 col-12 form-group" id="QualidadeInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtQualidade">Qualidade *</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtQualidade" name="txtQualidade" class="form-control" placeholder="Qualidade">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Qualidade" name="btn-Qualidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Qualidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-6 col-12 form-group" id="SetorInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtSetor">Setor *</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSetor" name="txtSetor" class="form-control" placeholder="Setor">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Setor" name="btn-Setor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Setor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="row marginTop">
                                <div class="col-md-6 col-12">
                                  <label data-error="wrong" data-success="right" for="txtProduto">Produto </label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Produto" name="btn-Setor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Produto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-6 col-12">
                                  <label data-error="wrong" data-success="right" for="txtCor">Cor</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" placeholder="Cor">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnLimpaCor" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="row marginTop" style="margin-bottom: 15px">
                                <div class="col-4 col-md-2">
                                  <label for="txtQuantidade">Qtde *</label>
                                  <div class="relative">
                                    <input type="text" class="input-default focus form-control" id="txtQuantidade" value="">
                                  </div>
                                </div>
                                <div class="col-8 col-md-4 col-sm-8">
                                  <div class="row">
                                    <label style="display: flex; text-align: center; justify-content: space-between" data-error="wrong" id="labelBarras" data-success="right" for="txtCodigo">Código de barras</label>
                                    <div class="col-md-1">
                                      <i title='desativar som bipagem' style="font-size: 20px" class="fas fa-volume-up somAtivo d-none"></i>
                                      <i title='ativar som bipagem' style="font-size: 20px" class="fas fa-volume-mute somInativo"></i>
                                    </div>
                                  </div>
                                  <div class="row input-group">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnMenosOuMais" data-button="absolute" type="button" data-estorno="false">
                                        <i class="m-0 p-0 fas fa-plus"></i>
                                      </button>
                                    </div>
                                    <input type="text" class="input-default focus form-control validate" id="txtCodigo" name="txtCodigo" placeholder="Barra">
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-12 col-md-auto">
                            <div class="col-auto">
                              <div class="d-flex" id="tipos">
                                <fieldset class="border-Field" style="width: 60% !important">
                                  <legend class="textoBorda">Tipo de Barra</legend>
                                  <div class="d-flex justify-content-start">
                                    <div class="row flex-row flex-md-column">
                                      <div class="icheck-primary m-3 m-md-0">
                                        <input class="ichecked barras focus" name="radioBarras" value="0" type="radio" id="checkTodos"> <label for="checkTodos">Todos</label>
                                      </div>
                                      <div class="icheck-primary m-3 m-md-0">
                                        <input class="form-check-input barras" name="radioBarras" value="1" type="radio" id="checkEan13"> <label for="checkEan13">Ean13</label>
                                      </div>
                                      <div class="icheck-primary m-3 m-md-0">
                                        <input class="form-check-input barras" name="radioBarras" value="2" type="radio" id="checkBarra28"> <label for="checkBarra28">Barra28</label>
                                      </div>
                                      <div class="icheck-primary m-3 m-md-0">
                                        <input class="form-check-input barras" name="radioBarras" value="3" type="radio" id="checkBarraCli"> <label for="checkBarraCli">BarraCli</label>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>
                            </div>
                            <div class="col-lg col-sm-12 mb-4 mb-md-0">
                              <div class="row col-12 col-sm-12 col-md-12 mt-2">
                                <button id="btnImportar" type="button" style="min-width: 120px;" class="btn btn-sisp btn-danger ml-2">Importação</button>
                              </div>
                              <div class="row col-12 col-sm-12 col-md-12 mt-2">
                                <button id="btnRfid" type="button" onclick="$('#modalRfid').modal('show')" class="btn btn-sisp btn-danger ml-2">RFID</button>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="table-responsive">
                            <table id="tabelaGerarInventarioLoja" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <td>CODIGO</td>
                                  <td><strong>QUANTIDADE</strong></td>
                                  <td>DESCRICAO</td>
                                  <td>DEPOSITO</td>
                                  <td>LOTE</td>
                                  <td>COR</td>
                                  <td>DESC_COR</td>
                                  <td>TAMANHO</td>
                                  <td>BARRA</td>
                                  <td>QUALIDADE</td>
                                  <td>CODIGO2</td>
                                  <td>BARRA28</td>
                                  <td>UNIDADE</td>
                                  <td>PREÇO</td>
                                  <td>POSSE</td>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-2" style="margin-top: 12px; padding-right: auto;">
                        <div class="flex">
                          <span class="info-box-icon"><i class="fas fa-box-open" style="font-size: 25px; margin-right: 5px; margin-top: 5px; color: var(--text-color)"></i></span>
                          <div class="info-box-content ">
                            <input type="number" name="txtQuantidadeBipada" id="txtQuantidadeBipada" class="form-control" data-bs-toggle="tooltip" title="Quantidade total de peças Bipadas" readonly>
                          </div>
                        </div>
                      </div>
                      <button type="button" id="btnGravar" style="font-size:15px; margin-right: 10px;" class="btn btn-danger btn-sisp action-button">Gravar</button>
                      <button type="button" id="btnCancelar" style="font-size:15px;" class="btn btn-success btn-sisp action-button-previous">Cancelar</button>
                    </form>
                  </div>
                </fieldset>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-grade" class="modal" data-backdrop="static" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Grade Produto</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <label for="">Codigo: <label id="lblCodigo" for=""></label> </label>
            <br>
            <label for="">Cor: <label id="lblDescricao" for=""></label></label>
            <div class="col-12 table-responsive">
              <table id="tabela-grade" class="table table-sm table-hover table-select table-condensed">
                <thead>
                  <tr>
                    <th>Tamanho</th>
                    <th width="100px">Saída</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">

              <button id="btnConfirmar" class="btn btn-danger btn-sisp" type="button">
                Confirmar
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Importação -->
    <div class="modal fade" id="modalImportarInventario" style="z-index: 99999">
      <div class="modal-dialog modal-dialog modal-md" id="tammodal">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Anexo</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0 pt-0">
            <div class="container-fluid">
              <div class="row">
                <div class="col-12 py-5">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArquivo">Arquivo:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtArquivo" disabled readonly name="txtArquivo" placeholder="Arquivo" accept=".csv">
                    <input type="file" id="mdModalUpload" class="d-none">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnAddArquivo" name="btnAddArquivo" type="file" for="txtArquivo" readonly="readonly"><i class="m-0 p-0 fas fa-folder-plus"></i> </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer px-0" class="d-flex">
              <div class="d-flex">
                <button type="button" class="btn btn-success btn-sisp action-button-previous" data-dismiss="modal" id="fechaModal">Fechar</button>  
                <button class="btn btn-danger btn-sisp alteraBotao" id="btnIncluirAnexo">Incluir</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalRfid" style="z-index: 99999">
      <div class="modal-dialog modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">RFID</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0 pt-0">
            <div class="container-fluid">
              <div class="row">
                <div class="col-12 py-5">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumLeitura">Número leitura:</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNumLeitura" name="txtNumLeitura" placeholder="Número leitura">
                    <div class="input-group-append">
                      <button class="btn bg-danger" onclick="$('#txtNumLeitura').val('')" type="file" for="txtNumLeitura" readonly="readonly"><i class="m-0 p-0 fas fa-trash"></i> </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer px-0" class="d-flex">
              <div class="d-flex">
                <button type="button" onclick="$('modalRfid').modal('hide')" class="btn btn-success btn-sisp action-button-previous" data-dismiss="modal">Fechar</button>  
                <button class="btn btn-danger btn-sisp alteraBotao" id="btnImportarRfid">Importar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <input type="text" class="d-none" id="ultimoCodigo">

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php
    include_once('../../../modais.php');
    ?>
    <?php include_once('../../../menu_fiscal.php'); ?>
  </main>

  <script src="plugins/jquery/jquery.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.261.6.2"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.6.2"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.261.6.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.6.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.6.2"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.261.6.2"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.261.6.2"></script>
  <script src="dist/js/sisplan.js?versao=3.261.6.2"></script>
  <script src="utils/funcoes.js?versao=3.261.6.2"></script>
  <script src="utils/cookies.js?versao=3.261.6.2"></script>
  <script src="dist/js/driver.min.js?versao=3.261.6.2"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-scrollTo/2.1.3/jquery.scrollTo.min.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      sArquivo = `${BASE_URI}/pages/inventario/gerainventario/gerainventario.js?versao=3.261.6.2`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      const temAcesso = await temAcessoTela('INVENTARIO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);

    });
  </script>
</body>

</html>